/*  change video based on switch presses from Arduino
 *   --> video switch takes place in draw loop
 *
 *  original from Dan Shifman's processing Video Tutorial
 *   https://processing.org/tutorials/video
 *
 *  Setup circuit & Arduino - see documentation in the Arduino Sketch
 * 
 *  modified fred Wolflink @ MassArt 2/22/17
*/

import processing.serial.*; 
import processing.video.*;

Serial arduino;       // The serial port Arduino is connected to (over USB)
int buttonValue = 0;  // set initial value
int oldButtonValue;
int mySwitch;

Movie movie1;
Movie movie2;

void setup() {
  size(320, 240);
  background(0);
  // List all the available serial ports
  printArray(Serial.list());

  // Open the port you are using at the rate you want:
  // update [0] below to match the actual port listed in the console
  // should be /dev/tty.usbmodem1411 on a Mac
  arduino = new Serial(this, Serial.list()[1], 9600);
  //movies
  movie1 = new Movie(this, "countdown.mov");
  movie2 = new Movie(this, "crashtest.mov");
}

void draw() {
  if (mySwitch == 1) {
    movie1.play();
    image(movie1, 0, 0, width, height);
  } else {
    movie1.stop();
  }

  if (mySwitch == 2) {
    movie2.play();
    image(movie2, 0, 0, width, height);
  } else {
    movie2.stop();
  }
}

/*
  SerialEvent occurs whenever a new data comes in the
 hardware serial RX.  This routine is run between each
 time loop() runs, so using delay inside loop can delay
 response.  Multiple bytes of data may be available.
 */
void serialEvent(Serial arduino) {
  buttonValue = arduino.read();
  if ( (buttonValue != oldButtonValue) && (buttonValue != 0) ) {
    mySwitch = buttonValue;
    oldButtonValue = buttonValue;
    println(mySwitch);
  }
}

// own movie function
void movieEvent(Movie m) {
  m.read();
}